/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.Computer;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SoftSwitch {
    private Boolean state;
    private Boolean initalState;
    private List<RAMListener> listeners;
    private final List<Integer> exclusionActivate = new ArrayList<Integer>();
    private final List<Integer> exclusionDeactivate = new ArrayList<Integer>();
    private final List<Integer> exclusionQuery = new ArrayList<Integer>();
    private String name;
    private boolean toggleType = false;

    public SoftSwitch(String name, Boolean initalState) {
        this.initalState = initalState;
        this.state = initalState;
        this.listeners = new ArrayList<RAMListener>();
        this.name = name;
    }

    public SoftSwitch(String name, int offAddress, int onAddress, int queryAddress, RAMEvent.TYPE changeType, Boolean initalState) {
        if (onAddress == offAddress && onAddress != -1) {
            this.toggleType = true;
            System.out.println("Switch " + name + " is a toggle type switch!");
        }
        this.initalState = initalState;
        this.state = initalState;
        this.listeners = new ArrayList<RAMListener>();
        this.name = name;
        int[] onAddresses = null;
        int[] offAddresses = null;
        int[] queryAddressList = null;
        if (onAddress >= 0) {
            onAddresses = new int[]{onAddress};
        }
        if (offAddress >= 0) {
            offAddresses = new int[]{offAddress};
        }
        if (queryAddress >= 0) {
            queryAddressList = new int[]{queryAddress};
        }
        this.init(offAddresses, onAddresses, queryAddressList, changeType);
    }

    public SoftSwitch(String name, int[] offAddrs, int[] onAddrs, int[] queryAddrs, RAMEvent.TYPE changeType, Boolean initalState) {
        this(name, initalState);
        this.init(offAddrs, onAddrs, queryAddrs, changeType);
    }

    private void init(int[] offAddrs, int[] onAddrs, int[] queryAddrs, RAMEvent.TYPE changeType) {
        RAMListener l;
        int endAddr;
        int beginAddr;
        ArrayList<Integer> addrs;
        if (this.toggleType) {
            addrs = new ArrayList<Integer>();
            for (int i : onAddrs) {
                addrs.add(i);
            }
            Collections.sort(addrs);
            beginAddr = (Integer)addrs.get(0);
            endAddr = (Integer)addrs.get(addrs.size() - 1);
            for (int i = beginAddr; i < endAddr; ++i) {
                if (addrs.contains(i)) continue;
                this.exclusionActivate.add(i);
            }
            l = new RAMListener(changeType, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

                protected void doConfig() {
                    this.setScopeStart(beginAddr);
                    this.setScopeEnd(endAddr);
                }

                protected void doEvent(RAMEvent e) {
                    if (!SoftSwitch.this.exclusionActivate.contains(e.getAddress())) {
                        SoftSwitch.this.setState(!SoftSwitch.this.getState());
                    }
                }
            };
            this.addListener(l);
        } else {
            if (onAddrs != null) {
                addrs = new ArrayList();
                for (int i : onAddrs) {
                    addrs.add(i);
                }
                Collections.sort(addrs);
                beginAddr = (Integer)addrs.get(0);
                endAddr = (Integer)addrs.get(addrs.size() - 1);
                for (int i = beginAddr; i < endAddr; ++i) {
                    if (addrs.contains(i)) continue;
                    this.exclusionActivate.add(i);
                }
                l = new RAMListener(changeType, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

                    protected void doConfig() {
                        this.setScopeStart(beginAddr);
                        this.setScopeEnd(endAddr);
                    }

                    protected void doEvent(RAMEvent e) {
                        if (!SoftSwitch.this.exclusionActivate.contains(e.getAddress())) {
                            SoftSwitch.this.setState(true);
                        }
                    }
                };
                this.addListener(l);
            }
            if (offAddrs != null) {
                addrs = new ArrayList();
                for (int i : offAddrs) {
                    addrs.add(i);
                }
                beginAddr = (Integer)addrs.get(0);
                endAddr = (Integer)addrs.get(addrs.size() - 1);
                for (int i = beginAddr; i < endAddr; ++i) {
                    if (addrs.contains(i)) continue;
                    this.exclusionDeactivate.add(i);
                }
                l = new RAMListener(changeType, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

                    protected void doConfig() {
                        this.setScopeStart(beginAddr);
                        this.setScopeEnd(endAddr);
                    }

                    protected void doEvent(RAMEvent e) {
                        if (!SoftSwitch.this.exclusionDeactivate.contains(e.getAddress())) {
                            SoftSwitch.this.setState(false);
                        }
                    }
                };
                this.addListener(l);
            }
        }
        if (queryAddrs != null) {
            addrs = new ArrayList();
            for (int i : queryAddrs) {
                addrs.add(i);
            }
            final int beginAddr2 = (Integer)addrs.get(0);
            endAddr = (Integer)addrs.get(addrs.size() - 1);
            for (int i = beginAddr2; i < endAddr; ++i) {
                if (addrs.contains(i)) continue;
                this.exclusionQuery.add(i);
            }
            RAMListener l2 = new RAMListener(RAMEvent.TYPE.READ, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

                protected void doConfig() {
                    this.setScopeStart(beginAddr2);
                    this.setScopeEnd(endAddr);
                }

                protected void doEvent(RAMEvent e) {
                    if (!SoftSwitch.this.exclusionQuery.contains(e.getAddress())) {
                        e.setNewValue(0xFF & SoftSwitch.this.readSwitch());
                    }
                }
            };
            this.addListener(l2);
        }
        this.register();
    }

    public boolean inhibit() {
        return false;
    }

    protected abstract byte readSwitch();

    protected void addListener(RAMListener l) {
        this.listeners.add(l);
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        if (this.initalState != null) {
            this.setState(this.initalState);
        }
    }

    public void register() {
        RAM m = Computer.getComputer().getMemory();
        for (RAMListener l : this.listeners) {
            m.addListener(l);
        }
    }

    public void unregister() {
        RAM m = Computer.getComputer().getMemory();
        for (RAMListener l : this.listeners) {
            m.removeListener(l);
        }
    }

    public final void setState(boolean newState) {
        if (this.inhibit()) {
            return;
        }
        this.state = newState;
        this.stateChanged();
    }

    public final boolean getState() {
        if (this.state == null) {
            return false;
        }
        return this.state;
    }

    public abstract void stateChanged();
}

